#target photoshop
app.bringToFront();

// === FRAME PARAMETERS ===
var targetWidth  = 370; // px
var targetHeight = 500; // px

// --- helpers ---
function baseNoExt(name){ return name.replace(/\.[^\.]+$/, ""); }
function mapMode(docMode) {
    switch (docMode) {
        case DocumentMode.RGB:          return NewDocumentMode.RGB;
        case DocumentMode.CMYK:         return NewDocumentMode.CMYK;
        case DocumentMode.GRAYSCALE:    return NewDocumentMode.GRAYSCALE;
        case DocumentMode.BITMAP:       return NewDocumentMode.BITMAP;
        case DocumentMode.LAB:          return NewDocumentMode.LAB;
        case DocumentMode.MULTICHANNEL: return NewDocumentMode.MULTICHANNEL;
        default:                        return NewDocumentMode.RGB;
    }
}
function fitContainAndCenter(layer, tw, th) {
    var b = layer.bounds; // [L,T,R,B] UnitValue
    var w = b[2].value - b[0].value;
    var h = b[3].value - b[1].value;
    if (w <= 0 || h <= 0) return;
    var scale = Math.min(tw / w, th / h) * 100;
    layer.resize(scale, scale, AnchorPosition.MIDDLECENTER);
    var nb = layer.bounds;
    var cx = (nb[0].value + nb[2].value)/2;
    var cy = (nb[1].value + nb[3].value)/2;
    layer.translate((tw/2)-cx, (th/2)-cy);
}

// Force ruler units to pixels
var _prevUnits = app.preferences.rulerUnits;
app.preferences.rulerUnits = Units.PIXELS;

try {
    // Смещение по Y (положительное = вниз, отрицательное = вверх)
    var yOffset = Number(prompt("На сколько пикселей сдвинуть изображение? (отрицательное = вверх)", "0"));
    if (isNaN(yOffset)) yOffset = 0;

    var files = File.openDialog(
        "Выберите изображения",
        "*.jpg;*.jpeg;*.png;*.tif;*.tiff;*.psd;*.webp",
        true
    );
    if (!files) { alert("Файлы не выбраны"); exit(); }

    var outFolder = new Folder(files[0].parent + "/exported");
    if (!outFolder.exists) outFolder.create();

    for (var i = 0; i < files.length; i++) {
        var f = files[i];
        var srcDoc = app.open(f);

        // Создаём целевой документ с режимом/битностью как у исходника
        var newDoc = app.documents.add(
            targetWidth,
            targetHeight,
            srcDoc.resolution,
            baseNoExt(f.name),
            mapMode(srcDoc.mode),           // <-- фикс аргумента 5
            DocumentFill.TRANSPARENT,
            1,
            srcDoc.bitsPerChannel
        );

        // --- Перенос изображения в целевой документ ---
        var placed = false;
        try {
            app.activeDocument = srcDoc;

            // Гарантируем обычный растровый слой
            if (srcDoc.activeLayer.kind !== LayerKind.NORMAL || srcDoc.activeLayer.isBackgroundLayer) {
                srcDoc.flatten();
            }

            // Дублируем (явный placement помогает)
            srcDoc.activeLayer.duplicate(newDoc, ElementPlacement.PLACEATBEGINNING);
            placed = true;
        } catch (dupErr) {
            // Фолбэк: Copy Merged → Paste (почти всегда проходит)
            try {
                app.activeDocument = srcDoc;
                srcDoc.flatten();
                srcDoc.selection.selectAll();
                srcDoc.selection.copy(true); // copyMerged

                app.activeDocument = newDoc;
                newDoc.paste();
                placed = true;
            } catch (pasteErr) {
                placed = false;
            }
        }

        // Закрыть исходник
        app.activeDocument = srcDoc;
        srcDoc.close(SaveOptions.DONOTSAVECHANGES);

        if (!placed) {
            app.activeDocument = newDoc;
            newDoc.close(SaveOptions.DONOTSAVECHANGES);
            alert('Пропущен файл: ' + decodeURI(f.name) + ' (не удалось перенести слой)');
            continue;
        }

        // --- Работаем в новом документе ---
        app.activeDocument = newDoc;
        var img = newDoc.activeLayer; img.name = "Image";

        // Подгоняем по contain + центрируем
        fitContainAndCenter(img, targetWidth, targetHeight);

        // Смещение по Y от пользователя
        if (yOffset !== 0) img.translate(0, yOffset);

        // Сохранение PNG
        var out = new File(outFolder + "/" + baseNoExt(f.name) + ".png");
        var png = new PNGSaveOptions();
        newDoc.saveAs(out, png, true, Extension.LOWERCASE);

        // Закрыть без сохранения
        newDoc.close(SaveOptions.DONOTSAVECHANGES);
    }

    alert("Готово! Файлы в папке: " + outFolder.fsName);
}
catch (e) {
    alert("Ошибка: " + e);
}
finally {
    app.preferences.rulerUnits = _prevUnits;
}